-- GHOST RECON MENU SCRIPT v1.1

if inGame() and isPlaying() then
	----------------------------
	-- NORMALIZER --
	----------------------------
	if not _uvSmallLoot then _uvSmallLoot = PlayerManager.upgrade_value end
	if not _uvlSmallLoot then _uvlSmallLoot = PlayerManager.upgrade_value_by_level end
	if not _ecmJamBat then _ecmJamBat = ECMJammerBase.update end
	if not _oldCooldn then _oldCooldn = PlayerManager.carry_blocked_by_cooldown end 
	if not _setWhisper then _setWhisper = GroupAIStateBase.set_whisper_mode end
	if not _civSnitch then _civSnitch = CivilianLogicFlee.clbk_chk_call_the_police end
	if not _lastBullet then _lastBullet = nil end
	if not _bulletCollision then _bulletCollision = InstantBulletBase.on_collision end
	if not _oldFOV then _oldFOV = PlayerStandard._check_action_weapon_gadget end 
	if not _actionRequest then _actionRequest = CopMovement.action_request end
	if not _setCool then _setCool = CopMovement.set_cool end
	if not _setObjective then _setObjective = CopBrain.set_objective end
	if not _setStance then _setStance = CopMovement.set_stance end
	if not _setStanceCode then _setStanceCode = CopMovement.set_stance_by_code end
	if not _setInteraction then _setInteraction = CopLogicInactive._set_interaction end
	if not _setAllowFire then _setAllowFire = CopMovement.set_allow_fire end
	if not _setAllowFireClient then _setAllowFireClient = CopMovement.set_allow_fire_on_client end
	---------------------
	---- FUNCTIONS ------
	---------------------
	setcool = setcool or function()
		function CopMovement:set_cool( state, giveaway )
			if state == true then _setCool(self, state, giveaway) end
		end
	end
	setwhisp = setwhisp or function()
		function GroupAIStateBase:set_whisper_mode( enabled )
			if enabled == true then _setWhisper(self, true) end
		end
	end
	copobjective = copobjective or function()
		function CopBrain:set_objective( new_objective )
			if (not new_objective) or (new_objective.stance ~= "hos" and new_objective.attitude ~= "engage") then _setObjective(self, new_objective) end
		end
	end
	copstance = copstance or function()
		function CopMovement:set_stance( new_stance_name )
			if new_stance_name ~= "hos" then _setStance(self, new_stance_name) end
		end
	end
	copsetstance = copsetstance or function()
		function CopMovement:set_stance_by_code( new_stance_code )
			if new_stance_code == 1 then _setStanceCode(self, new_stance_code) end
		end
	end
	pagerinteract = pagerinteract or function()
		function CopLogicInactive._set_interaction( data, my_data )
			data.char_tweak.has_alarm_pager = false
			_setInteraction(data, my_data)
		end
	end
	allowfire = allowfire or function()
		function CopMovement:set_allow_fire( state )
			if state == false then _setAllowFire(self, state) end
		end
	end
	allowfirecli = allowfirecli or function()
		function CopMovement:set_allow_fire_on_client( state, unit )
			if state == false then _setAllowFireClient(self, state, unit) end
		end
	end
	nopanic = nopanic or function()
		-- Stops panic buttons & intel burning
		function CopMovement:action_request( action_desc )
		-- Prevents panic buttons & intel burning (intercepting the 'run' action is the only way; for example, if you intercept events such as 'e_so_alarm_under_table' to prevent intel burning, the animation will not happen but the fire will still appear)
		if action_desc.variant == "run" then return false end
		if action_desc.variant == "e_so_alarm_under_table" then return false end
		if action_desc.variant == "cmf_so_press_alarm_wall" then return false end
		if action_desc.variant == "cmf_so_press_alarm_table" then return false end
		if action_desc.variant == "cmf_so_call_police" then return false end
		if action_desc.variant == "arrest_call" then return false end
		return _actionRequest(self, action_desc)
		end
	end
	supressed = supressed or function()
		function CopMovement:on_suppressed( state ) end
	end
	idlecop = idlecop or function()
		function CopLogicBase._get_logic_state_from_reaction( data, reaction ) return "idle" end 
	end
	onalert = onalert or function()
		function CopLogicIdle.on_alert( data, alert_data ) end 
	end
	policecall = policecall or function()
		function GroupAIStateBase:on_police_called( called_reason ) end 
	end
	polweaphot = polweaphot or function()
		function GroupAIStateBase:on_police_weapons_hot( called_reason ) end 
	end
	gangweaphot = gangweaphot or function()
		function GroupAIStateBase:on_gangster_weapons_hot( called_reason ) end 
	end
	enemyweaphot = enemyweaphot or function()
		function GroupAIStateBase:on_enemy_weapons_hot( is_delayed_callback ) end 
	end
	alertlisten = alertlisten or function()
		function GroupAIStateBase:add_alert_listener( id, clbk, filter_num, types, m_pos ) end
	end
	crimspot = crimspot or function()
		function GroupAIStateBase:criminal_spotted( unit ) end 
	end
	reportaggro = reportaggro or function()
		function GroupAIStateBase:report_aggression( unit ) end 
	end
	propalert = propalert or function()
		function GroupAIStateBase:propagate_alert( alert_data ) end
	end
	crimsuspect = crimsuspect or function()
		function GroupAIStateBase:on_criminal_suspicion_progress( u_suspect, u_observer, status ) end
	end
	onsuspic = onsuspic or function()
		function PlayerMovement:on_suspicion( observer_unit, status ) end 
	end
	updsuspic = updsuspic or function()
		function SecurityCamera:_upd_suspicion( t ) end 
	end
	cameraalarm = cameraalarm or function()
		function SecurityCamera:_sound_the_alarm( detected_unit ) end 
	end
	suspicsound = suspicsound or function()
		function SecurityCamera:_set_suspicion_sound( suspicion_level ) end 
	end
	-- SMALL LOOT MODIFIER 1: ((upgrade) normalizable )
	ghostloot = ghostloot or function()
		function PlayerManager:upgrade_value( category, upgrade, default ) 
			if category == "player" and upgrade == "small_loot_multiplier" then 
				return 10
			else 
				return _uvSmallLoot(self, category, upgrade, default) 
			end 
		end
	-- SMALL LOOT MODIFIER 2: ((level adjustx10) normalizable )	
		function PlayerManager:upgrade_value_by_level( category, upgrade, level, default ) 
			if category == "player" and upgrade == "small_loot_multiplier" then 
				return 10
			else 
				return _uvlSmallLoot(self, category, upgrade, level, default) 
			end 
		end
	end
	-- INFINITE ECM JAMMER BATTERY (normalizable)
	ghostecm = ghostecm or function()
		function ECMJammerBase:update( unit, t, dt )
			self._battery_life = self._max_battery_life
		end
	end
	-- REMOVE COOLDOWN BETWEEN PICKING UP BAGS (normalizable)
	ghostcool = ghostcool or function()
		function PlayerManager:carry_blocked_by_cooldown() 
		return false 
		end 
	end
	-- STEALTH ENHANCER/WHISPER ((Allows answer pagers, bag corpses, and spot NPC's movement) normalizable)
	ghostwhisper = ghostwhisper or function()
		function GroupAIStateBase:set_whisper_mode( enabled )
			if enabled == true 
			then _setWhisper(self, true) 
			end
		end
	end
	-- NO CIV SNITCHING (normalizable)
	ghostsnitch = ghostsnitch or function()
		function CivilianLogicFlee.clbk_chk_call_the_police( ignore_this, data ) 
		end
	end
	-- WARP TO BULLET (normalizable)
	ghostwarp = ghostwarp or function()
		function InstantBulletBase:on_collision( col_ray, weapon_unit, user_unit, damage, blank )
			if user_unit == managers.player:player_unit() then
				_lastBullet = col_ray.hit_position
			end
			return _bulletCollision(self, col_ray, weapon_unit, user_unit, damage, blank)
		end
	end
	-- FOV ENHANCED ATTACHMENT
	ghostfov = ghostfov or function()
		function PlayerStandard:_check_action_weapon_gadget( t, input ) 
		local new_fov = 0
		local new_sens = false
			if input.btn_weapon_gadget_press then
				if self._equipped_unit:base()._gadget_on then
				new_fov = 80 -- desired FOV without zoom goes here
				new_sens = false
				else
				new_fov = 20 -- zoom FOV goes here
				new_sens = true
				end
				if self._equipped_unit:base().toggle_gadget then
					if self._equipped_unit:base():has_gadget() then
						self._equipped_unit:base():toggle_gadget()
						self._unit:network():send( "set_weapon_gadget_state", self._equipped_unit:base()._gadget_on )
						self._camera_unit:base():set_fov_instant( new_fov )
						managers.menu:set_mouse_sensitivity( new_sens )
					end
				end
			end
		end
	end
	stateclean = stateclean or function()
		managers.player:set_player_state( "clean" )
	end
	statenorm = statenorm or function()
		managers.player:set_player_state( "standard" )
	end
	iphonycamapp = iphonycamapp or function()
		game_state_machine:change_state_by_name( "ingame_access_camera" )
	end
	spectatemodeenter = spectatemodeenter or function()
	game_state_machine:change_state_by_name( "ingame_waiting_for_respawn" )
	end
	spectatemodeleave = spectatemodeleave or function()
		if game_state_machine:current_state_name() == "ingame_waiting_for_respawn" and not alive(managers.player:player_unit()) then
			IngameWaitingForRespawnState:_begin_game_enter_transition()
		else
			stateclean()
			statenorm()
		end
	end
	hvidesnit = hvidesnit or function()
		dofiles("trainer/assets/lobotomy.lua")
	end
	
	deltaknight = deltaknight or function()
		dofiles("trainer/assets/disableallcams.lua")
	end 
	
	-----------------------
	-- ACTIVATE GRCHEATS --
	-----------------------
	ghostreconset = ghostreconset or function()
		-- ghostloot()
		-- ghostecm()
		-- ghostcool()
		-- ghostwhisper()
		ghostsnitch()
		ghostwarp()
		ghostfov()
		show_mid_text("..hiding in plain sight", "Ghost recon", 3 )
	end

	----------------
	-- MENU --
	----------------
	callghostmenu = callghostmenu or function()
		openmenu(ghostreconmenu)
	end
	callghostoptmenu = callghostoptmenu or function()
		openmenu(ghostoptmenu)
	end
	callghostoptmenu2 = callghostoptmenu2 or function()
		openmenu(ghostoptmenu2)
	end

	-- GHOST MENU INGAME
	ghostopti = ghostopti or {
		{ text = "返回", callback = callghostmenu },
		{ text = "", is_cancel_button = true},
		{ text = "你不会被摄像头发现", callback = suspicsound },
		{ text = "Q键增强变焦", callback = ghostfov },
		{ text = "原地观看摄像头", callback = iphonycamapp },
		{ text = "摘掉面具", callback = spectatemodeenter },
		{ text = "戴上面具", callback = spectatemodeleave },
		{ text = "敌人不会向你开枪", callback = allowfire },
		{ text = "关闭警报线路", callback = policecall },
		{ text = "摄像头不再报警", callback = cameraalarm },
		{ text = "关闭所有摄像头", callback = deltaknight },
		{ text = "NPC对你没有反应", callback = hvidesnit },
		}
	ghostoptmenu = ghostoptmenu or SimpleMenu:new("幽灵行动菜单", "偷偷摸摸,鬼鬼祟祟.",ghostopti)
	-- GHOST EXPERIMENTAL OPTIONS INGAME
	ghostopti2 = ghostopti2 or {
		{ text = "返回", callback = callghostmenu },
		{ text = "", is_cancel_button = true},
		{ text = "设置冷却时间(作用不明)", callback = setcool },
		{ text = "窃窃私语模式(作用不明)", callback = setwhisp },
		{ text = "警察的目标(作用不明)", callback = copobjective },
		{ text = "警察的位置(作用不明)", callback = copstance },
		{ text = "设置警察位置(作用不明)", callback = copsetstance },
		{ text = "秒回对讲机", callback = pagerinteract },
		{ text = "开火不会触发警报", callback = allowfirecli },
		{ text = "平民不会惊恐", callback = nopanic },
		{ text = "镇压状态", callback = supressed },
		{ text = "怠慢的警察)", callback = idlecop },
		{ text = "警惕的警察", callback = onalert },
		{ text = "允许警察开火", callback = polweaphot },
		{ text = "允许黑帮开火", callback = gangweaphot },
		{ text = "允许敌人开火", callback = enemyweaphot },
		{ text = "警报监听者(作用不明)", callback = alertlisten },
		{ text = "犯罪行为被发现(作用不明)", callback = crimspot },
		{ text = "犯罪行为被报告(作用不明)", callback = reportaggro },
		{ text = "警惕状态传播(作用不明)", callback = propalert },
		{ text = "犯罪行为被怀疑状态(作用不明)", callback = crimsuspect },
		{ text = "涉嫌状态(作用不明)", callback = onsuspic },
		{ text = "加强摄像头怀疑度(作用不明)", callback = updsuspic },
		}
	ghostoptmenu2 = ghostoptmenu2 or SimpleMenu:new("幽灵行动菜单", "以下功能为实验阶段",ghostopti2)
	-- ROOT MENU
	ghostopt = ghostopt or {
		{ text = "退出", is_cancel_button = true},
		{},
		{ text = "幽灵行动菜单[实验]", callback = callghostoptmenu2 },
		{ text = "幽灵行动菜单", callback = callghostoptmenu },
		{},
		{ text = "开启幽灵行动菜单内所有功能", callback = ghostreconset },
		}
	if not ghostreconmenu then
		ghostreconmenu = ghostreconmenu or SimpleMenu:new("幽灵行动菜单", "你就像幽灵一样.", ghostopt)
	end
	ghostreconmenu:show()
else
dofiles("trainer/F9 - SKILL MENU.lua")
end